/**
 * AJAX helper for the tag management page.
 *
 * @module     core/tag
 * @copyright  2015 Marina Glancy
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.0
 */
define("core/tag",["jquery","core/ajax","core/templates","core/notification","core/str","core/modal_factory","core/modal_events","core/pending"],(function($,ajax,templates,notification,str,ModalFactory,ModalEvents,Pending){return{initTagindexPage:function(){$("body").delegate(".tagarea[data-ta] a[data-quickload=1]","click",(function(e){var pendingPromise=new Pending("core/tag:initTagindexPage");e.preventDefault();var target=$(this),query=target[0].search.replace(/^\?/,""),tagarea=target.closest(".tagarea[data-ta]"),args=query.split("&").reduce((function(s,c){var t=c.split("=");return s[t[0]]=decodeURIComponent(t[1]),s}),{});ajax.call([{methodname:"core_tag_get_tagindex",args:{tagindex:args}}])[0].then((function(data){return templates.render("core_tag/index",data)})).then((function(html,js){templates.replaceNode(tagarea,html,js)})).always(pendingPromise.resolve).catch(notification.exception)}))},initManagePage:function(){$("body").on("updated","[data-inplaceeditable]",(function(e){var pendingPromise=new Pending("core/tag:initManagePage");if(str.get_strings([{key:"selecttag",component:"core_tag"},{key:"now",component:"core"}]).then((function(result){$('label[for="tagselect'+e.ajaxreturn.itemid+'"]').html(result[0]),$(e.target).closest("tr").find("td.col-timemodified").html(result[1])})).always(pendingPromise.resolve).catch(notification.exception),"tagflag"===e.ajaxreturn.itemtype){var row=$(e.target).closest("tr");"0"===e.ajaxreturn.value?row.removeClass("table-warning"):row.addClass("table-warning")}})),$(".tag-management-table").delegate("a.tagdelete","click",(function(e){var pendingPromise=new Pending("core/tag:tagdelete");e.preventDefault();var href=$(this).attr("href");str.get_strings([{key:"delete",component:"core"},{key:"confirmdeletetag",component:"tag"},{key:"yes",component:"core"},{key:"no",component:"core"}]).then((function(s){return notification.confirm(s[0],s[1],s[2],s[3],(function(){window.location.href=href}))})).always(pendingPromise.resolve).catch(notification.exception)})),$("#tag-management-delete").click((function(e){var form=$(this).closest("form").get(0);if($(form).find("input[data-togglegroup='tags-manage'][data-toggle='slave']:checked").length){var pendingPromise=new Pending("core/tag:tag-management-delete"),tempElement=$("<input type='hidden'/>").attr("name",this.name);e.preventDefault(),str.get_strings([{key:"delete",component:"core"},{key:"confirmdeletetags",component:"tag"},{key:"yes",component:"core"},{key:"no",component:"core"}]).then((function(s){return notification.confirm(s[0],s[1],s[2],s[3],(function(){tempElement.appendTo(form),form.submit()}))})).always(pendingPromise.resolve).catch(notification.exception)}})),$("#tag-management-combine").click((function(e){var pendingPromise=new Pending("core/tag:tag-management-combine");e.preventDefault();var form=$(this).closest("form").get(0),tags=$(form).find("input[data-togglegroup='tags-manage'][data-toggle='slave']:checked");if(tags.length<=1)str.get_strings([{key:"combineselected",component:"tag"},{key:"selectmultipletags",component:"tag"},{key:"ok"}]).then((function(s){return notification.alert(s[0],s[1],s[2])})).always(pendingPromise.resolve).catch(notification.exception);else{var tempElement=$("<input type='hidden'/>").attr("name",this.name),saveButtonText="",tagOptions=[];tags.each((function(){var tagid=$(this).val(),tagname=$(".inplaceeditable[data-itemtype=tagname][data-itemid="+tagid+"]").attr("data-value");tagOptions.push({id:tagid,name:tagname})})),str.get_strings([{key:"combineselected",component:"tag"},{key:"continue",component:"core"}]).then((function(langStrings){var modalTitle=langStrings[0];saveButtonText=langStrings[1];var templateContext={tags:tagOptions};return ModalFactory.create({title:modalTitle,body:templates.render("core_tag/combine_tags",templateContext),type:ModalFactory.types.SAVE_CANCEL})})).then((function(modal){return modal.setSaveButtonText(saveButtonText),modal})).then((function(modal){modal.getRoot().on(ModalEvents.save,(function(e){e.preventDefault(),tempElement.appendTo(form);var maintag=$("input[name=maintag]:checked","#combinetags_form").val();$("<input type='hidden'/>").attr("name","maintag").attr("value",maintag).appendTo(form),form.submit()})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show(),$("#combinetags_form input[type=radio]").first().focus().prop("checked",!0)})).always(pendingPromise.resolve).catch(notification.exception)}})),$("body").on("updatefailed","[data-inplaceeditable][data-itemtype=tagname]",(function(e){var exception=e.exception,newvalue=e.newvalue,tagid=$(e.target).attr("data-itemid");if("namesalreadybeeingused"===exception.errorcode){var pendingPromise=new Pending("core/tag:updatefailed");e.preventDefault(),str.get_strings([{key:"confirm",component:"core"},{key:"nameuseddocombine",component:"tag"},{key:"yes",component:"core"},{key:"cancel",component:"core"}]).then((function(s){return notification.confirm(s[0],s[1],s[2],s[3],(function(){window.location.href=window.location.href+"&newname="+encodeURIComponent(newvalue)+"&tagid="+encodeURIComponent(tagid)+"&action=renamecombine&sesskey="+M.cfg.sesskey}))})).always(pendingPromise.resolve).catch(notification.exception)}})),$("body").on("click","a[data-action=addstandardtag]",(function(e){var pendingPromise=new Pending("core/tag:addstandardtag");return e.preventDefault(),ModalFactory.create({title:str.get_string("addotags","tag"),body:templates.render("core_tag/add_tags",{actionurl:window.location.href,sesskey:M.cfg.sesskey}),type:ModalFactory.types.SAVE_CANCEL}).then((function(modal){modal.setSaveButtonText(str.get_string("continue","core")),modal.getRoot().on(ModalEvents.save,(function(e){var tagsInput=$(e.currentTarget).find("#id_tagslist"),name=tagsInput.val().trim();tagsInput.val(name);var tagsForm=$("#addtags_form");return tagsForm.on("submit",(function(e){var form=$("#addtags_form");!1===form[0].checkValidity()&&(e.preventDefault(),e.stopPropagation()),form.addClass("was-validated"),$('[data-region="tagslistinput"]').addClass("error");var errorMessage=$("#id_tagslist_error_message");errorMessage.removeAttr("hidden"),errorMessage.addClass("help-block")})),tagsForm.submit(),!1})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show()})).always(pendingPromise.resolve).catch(notification.exception)}))},initManageCollectionsPage:function(){$("body").on("updated","[data-inplaceeditable]",(function(e){var areaid,collid,pendingPromise=new Pending("core/tag:initManageCollectionsPage-updated"),ajaxreturn=e.ajaxreturn;"core_tag"===ajaxreturn.component&&"tagareaenable"===ajaxreturn.itemtype&&(areaid=$(this).attr("data-itemid"),$(".tag-collections-table ul[data-collectionid] li[data-areaid="+areaid+"]").hide(),"1"===ajaxreturn.value?($(this).closest("tr").removeClass("dimmed_text"),collid=$(this).closest("tr").find('[data-itemtype="tagareacollection"]').attr("data-value"),$(".tag-collections-table ul[data-collectionid="+collid+"] li[data-areaid="+areaid+"]").show()):$(this).closest("tr").addClass("dimmed_text")),"core_tag"===ajaxreturn.component&&"tagareacollection"===ajaxreturn.itemtype&&(areaid=$(this).attr("data-itemid"),$(".tag-collections-table ul[data-collectionid] li[data-areaid="+areaid+"]").hide(),collid=$(this).attr("data-value"),"1"===$(this).closest("tr").find('[data-itemtype="tagareaenable"]').attr("data-value")&&$(".tag-collections-table ul[data-collectionid="+collid+"] li[data-areaid="+areaid+"]").show()),pendingPromise.resolve()})),$("body").on("click",".addtagcoll > a",(function(e){var pendingPromise=new Pending("core/tag:initManageCollectionsPage-addtagcoll");e.preventDefault();var href=$(this).attr("data-url"),saveButtonText="";str.get_strings([{key:"addtagcoll",component:"tag"},{key:"create",component:"core"}]).then((function(langStrings){var modalTitle=langStrings[0];saveButtonText=langStrings[1];var templateContext={actionurl:href,sesskey:M.cfg.sesskey};return ModalFactory.create({title:modalTitle,body:templates.render("core_tag/add_tag_collection",templateContext),type:ModalFactory.types.SAVE_CANCEL})})).then((function(modal){return modal.setSaveButtonText(saveButtonText),modal.getRoot().on(ModalEvents.save,(function(e){var collectionInput=$(e.currentTarget).find("#addtagcoll_name"),name=collectionInput.val().trim();collectionInput.val(name);var form=$("#addtagcoll_form");return form.on("submit",(function(e){!1===form[0].checkValidity()&&(e.preventDefault(),e.stopPropagation()),form.addClass("was-validated"),$('[data-region="addtagcoll_nameinput"]').addClass("error");var errorMessage=$("#id_addtagcoll_name_error_message");errorMessage.removeAttr("hidden"),errorMessage.addClass("help-block")})),form.submit(),!1})),modal.getRoot().on(ModalEvents.hidden,(function(){modal.destroy()})),modal.show(),modal})).always(pendingPromise.resolve).catch(notification.exception)})),$("body").on("click",".tag-collections-table .action_delete",(function(e){var pendingPromise=new Pending("core/tag:initManageCollectionsPage-action_delete");e.preventDefault();var href=$(this).attr("data-url")+"&sesskey="+M.cfg.sesskey;str.get_strings([{key:"delete"},{key:"suredeletecoll",component:"tag",param:$(this).attr("data-collname")},{key:"yes"},{key:"no"}]).then((function(s){return notification.confirm(s[0],s[1],s[2],s[3],(function(){window.location.href=href}))})).always(pendingPromise.resolve).catch(notification.exception)}))}}}));

//# sourceMappingURL=tag.min.js.map