/**
 * AMD module used when viewing the list of templates
 *
 * @module     tool_certificate/templates-list
 * @copyright  2019 Marina Glancy
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_certificate/templates-list",["jquery","core_form/modalform","core/notification","core/str","core/ajax","core/toast"],(function($,ModalForm,Notification,Str,Ajax,_ref){let{add:addToast}=_ref;var displayAddTemplate=function(e){var contextid=$(e.currentTarget).data("contextid");e.preventDefault();var modal=function(triggerElement,title,args){const modal=new ModalForm({formClass:"tool_certificate\\form\\details",args:args,modalConfig:{title:title},saveButtonText:Str.get_string("save"),returnFocus:triggerElement[0]});return modal.show(),modal}($(e.currentTarget),Str.get_string("createtemplate","tool_certificate"),{id:0,contextid:contextid});modal.addEventListener(modal.events.FORM_SUBMITTED,(e=>{e.preventDefault(),window.location.href=e.detail.url}))},displayIssue=function(e){e.preventDefault();const target=$(e.currentTarget);var modal=new ModalForm({formClass:"tool_certificate\\form\\certificate_issues",args:{tid:target.attr("data-tid")},modalConfig:{title:Str.get_string("issuecertificates","tool_certificate"),scrollable:!1},saveButtonText:Str.get_string("save"),returnFocus:target});modal.addEventListener(modal.events.FORM_SUBMITTED,(event=>{const data=parseInt(event.detail,10);data?Str.get_strings([{key:"oneissuewascreated",component:"tool_certificate"},{key:"aissueswerecreated",component:"tool_certificate",param:data}]).done((function(s){var str=data>1?s[1]:s[0];return addToast(str),null})).catch(Notification.exception):Str.get_string("noissueswerecreated","tool_certificate").done((function(s){return addToast(s),null})).catch(Notification.exception)})),modal.show()},duplicateMulticategory=function(e){e.preventDefault();const target=$(e.currentTarget),templateId=target.attr("data-id");var modal=new ModalForm({formClass:"tool_certificate\\form\\category_selector",args:{id:templateId},modalConfig:{title:Str.get_string("confirm")},saveButtonText:Str.get_string("duplicate","tool_certificate"),returnFocus:target});modal.addEventListener(modal.events.FORM_SUBMITTED,(function(){window.location.reload()})),modal.show()},duplicateSinglecategory=function(e){e.preventDefault();const templateId=$(e.currentTarget).attr("data-id");Str.get_strings([{key:"confirm",component:"moodle"},{key:"duplicatetemplateconfirm",component:"tool_certificate",param:$(e.currentTarget).attr("data-name")},{key:"duplicate",component:"tool_certificate"},{key:"cancel",component:"moodle"}]).done((function(s){Notification.confirm(s[0],s[1],s[2],s[3],(function(){Ajax.call([{methodname:"tool_certificate_duplicate_template",args:{id:templateId}}])[0].done((function(){window.location.reload()})).fail(Notification.exception)}))})).fail(Notification.exception)},deleteTemplate=function(e){e.preventDefault();const templateId=$(e.currentTarget).attr("data-id");Str.get_strings([{key:"confirm",component:"moodle"},{key:"deletetemplateconfirm",component:"tool_certificate",param:$(e.currentTarget).attr("data-name")},{key:"delete",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(s){Notification.confirm(s[0],s[1],s[2],s[3],(function(){Ajax.call([{methodname:"tool_certificate_delete_template",args:{id:templateId}}])[0].done((function(){window.location.reload()})).fail(Notification.exception)}))})).fail(Notification.exception)};return{init:function(){$("body").on("click",'[data-element="addbutton"]',displayAddTemplate).on("click",'[data-action="issue"]',displayIssue).on("click",'[data-action="duplicate"][data-selectcategory="1"]',duplicateMulticategory).on("click",'[data-action="duplicate"][data-selectcategory="0"]',duplicateSinglecategory).on("click",'[data-action="delete"]',deleteTemplate)}}}));

//# sourceMappingURL=templates-list.min.js.map